/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.computer.client;

import com.google.common.base.Preconditions;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ComputerScreen;
import com.mrcrayfish.furniture.refurbished.computer.Program;
import com.mrcrayfish.furniture.refurbished.computer.client.Scene;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;

public abstract class DisplayableProgram<T extends Program> {
    protected static final int MAX_CONTENT_WIDTH = 224;
    protected static final int MAX_CONTENT_HEIGHT = 108;
    protected final T program;
    protected final int width;
    protected final int height;
    protected int windowOutlineColour = -12107714;
    protected int windowTitleBarColour = -10791856;
    protected int windowTitleLabelColour = -14540251;
    protected int windowBackgroundColour = -14540251;
    @Nullable
    protected Scene scene;
    @Nullable
    private Listener listener;
    private int contentStart;
    private int contentTop;

    public DisplayableProgram(T program, int width, int height) {
        Preconditions.checkArgument((width >= 16 && width <= 224 ? 1 : 0) != 0, (Object)"Displayable program width must be between 16 and 224 (inclusive)");
        Preconditions.checkArgument((height >= 16 && height <= 108 ? 1 : 0) != 0, (Object)"Displayable program height must be between 16 and 108 (inclusive)");
        this.program = program;
        this.width = width;
        this.height = height;
    }

    public void update(int contentStart, int contentTop) {
        this.contentStart = contentStart;
        this.contentTop = contentTop;
        if (this.scene != null) {
            this.scene.updateWidgets(contentStart, contentTop);
        }
    }

    public void tick() {
        if (this.scene != null) {
            this.scene.tick();
        }
    }

    public void render(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.scene != null) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)this.contentStart, (float)this.contentTop, 0.0f);
            this.scene.render(graphics, mouseX, mouseY, partialTick);
            graphics.method_51448().method_22909();
            this.scene.getRenderables().forEach(widget -> widget.method_25394(graphics, mouseX, mouseY, partialTick));
        }
    }

    public final T getProgram() {
        return this.program;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    protected void setWindowOutlineColour(int colour) {
        this.windowOutlineColour = colour;
    }

    public int getWindowOutlineColour() {
        return this.windowOutlineColour;
    }

    protected void setWindowTitleBarColour(int colour) {
        this.windowTitleBarColour = colour;
    }

    public int getWindowTitleBarColour() {
        return this.windowTitleBarColour;
    }

    protected void setWindowTitleLabelColour(int colour) {
        this.windowTitleLabelColour = colour;
    }

    public int getWindowTitleLabelColour() {
        return this.windowTitleLabelColour;
    }

    protected void setWindowBackgroundColour(int colour) {
        this.windowBackgroundColour = colour;
    }

    public int getWindowBackgroundColour() {
        return this.windowBackgroundColour;
    }

    protected void setScene(@Nullable Scene newScene) {
        Scene oldScene = this.scene;
        this.scene = newScene;
        if (this.scene != null) {
            this.scene.updateWidgets(this.contentStart, this.contentTop);
        }
        if (this.listener != null) {
            this.listener.onChangeScene(oldScene, newScene);
        }
    }

    @Nullable
    public final Scene getScene() {
        return this.scene;
    }

    public final class_2561 translation(String key) {
        class_2960 id = ((Program)this.getProgram()).getId();
        return class_2561.method_43471((String)String.format("computer_program.%s.%s.%s", id.method_12836(), id.method_12832(), key));
    }

    public final void setListener(Listener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Listener can only be assigned once");
        this.listener = listener;
        if (this.scene != null) {
            listener.onChangeScene(null, this.scene);
        }
    }

    public boolean blocksNavigation() {
        return false;
    }

    public void onClose() {
        if (this.listener != null) {
            this.listener.onChangeScene(this.scene, null);
        }
    }

    public static class Listener {
        private final ComputerScreen screen;

        public Listener(ComputerScreen screen) {
            this.screen = screen;
        }

        public void onChangeScene(@Nullable Scene oldScene, @Nullable Scene newScene) {
            if (oldScene != null) {
                this.screen.removeWidgets(oldScene);
            }
            if (newScene != null) {
                this.screen.addWidgets(newScene);
            }
        }
    }
}

